% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenopath.R
\name{interactions}
\alias{interactions}
\title{Tidy summary of interactions}
\usage{
interactions(phenopath_fit, n = 3)
}
\arguments{
\item{phenopath_fit}{An object returned by a call to \code{phenopath}}

\item{n}{The number of standard deviations away from 0 the posterior of the 
interaction effect sizes should be to be designated as significant}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{feature} The feature (usually gene)
\item \code{covariate} The covariate, specified from the order originally supplied to 
the call to \code{phenopath}
\item \code{interaction_effect_size} The effect size of the interaction (\eqn{beta} 
from the statistical model)
\item \code{significant} Boolean for whether the interaction effect is significantly
different from 0
\item \code{chi} The precision of the ARD prior on \eqn{beta}
\item \code{pathway_loading} The pathway loading \eqn{lambda}, showing the overall
effect for each gene marginalised over the covariate
}
}
\description{
Computes a tidy data frame of the interaction effects, pathway scores, and significance for
each gene and covariate interaction.
}
\examples{
sim <- simulate_phenopath() 
fit <- phenopath(sim$y, sim$x, elbo_tol = 1e-2)
interactions(fit)
}
