% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/transforming.R
\name{transforming}
\alias{transforming}
\alias{transforming,MultiAssayExperiment-method}
\alias{transforming,SummarizedExperiment-method}
\alias{transforming,MultiDataSet-method}
\alias{transforming,ExpressionSet-method}
\title{Transformation of the data matrix intensities}
\usage{
transforming(
  x,
  method.vc = c("log2", "log10", "sqrt", "none")[1],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{transforming}{MultiAssayExperiment}(
  x,
  method.vc = c("log2", "log10", "sqrt", "none")[1],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{transforming}{SummarizedExperiment}(
  x,
  method.vc = c("log2", "log10", "sqrt", "none")[1],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{transforming}{MultiDataSet}(
  x,
  method.vc = c("log2", "log10", "sqrt", "none")[1],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{transforming}{ExpressionSet}(
  x,
  method.vc = c("log2", "log10", "sqrt", "none")[1],
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment}
or \code{MultiAssayExperiment} (\code{ExpressionSet} and \code{MultiDataSet}
are still supported)}

\item{method.vc}{character of length 1 or the total number of datasets:
transformation to be used for each dataset (either 'log2',
'log10', 'sqrt', or 'none')}

\item{report.c}{character(1): File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
\code{SummarizedExperiment} or \code{MultiAssayExperiment}
(or \code{ExpressionSet} and \code{MultiDataSet}) including the (list of)
matrix with transformed intensities
}
\description{
A logarithmic or square root transformation may be applied to the data matrix
intensities in (each of) the data set (e.g. to stabilize the variance)
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- correcting(sacurine.se)
sacurine.se <- sacurine.se[, colData(sacurine.se)[, "sampleType"] != "pool"]
sacurine.se <- transforming(sacurine.se)
# MultiAssayExperiment
prometis.mae <- reading(system.file("extdata/prometis",
                                    package = "phenomis"))
prometis.mae <- transforming(prometis.mae, method.vc = c("log2", "none"))
# Note: in the 'prometis' example data set from the package, the data are
# already log2 transformed
}
