% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_plots.R
\name{gg_pie}
\alias{gg_pie}
\title{Pie with ggplot2}
\usage{
gg_pie(
  data.tb,
  y.c = "",
  color.c = "",
  title.c = "",
  palette.vc = "Set1",
  label.c = c("none", "value", "percent")[1],
  geom_text.ls = list(lab.i = 7, legend_title.i = 16, legend_text.i = 14, title.i = 16),
  figure.c = c("interactive", "my_pie.pdf", "none")[1]
)
}
\arguments{
\item{data.tb}{Tibble (or data frame) containing the information}

\item{y.c}{Character: name of the column with the factor to be displayed;
alternatively, name of the column with the counts (in this case set the name
of the column with the names of the factor levels with the 'color.c'
argument)}

\item{color.c}{Character: optional name of the column with the names of the
factor levels}

\item{title.c}{Character: plot title}

\item{palette.vc}{Character: either the name of an RColorBrewer palette
(default: 'Set1'; 'Paired' can be useful for parallel plotting) or a vector
manually defining the colors}

\item{label.c}{Character: (relative) counts to be displayed on the pie;
either 'none' (default), 'value' or 'percent'}

\item{geom_text.ls}{List of sizes for lab.i (default 7), legend_title.i (16),
legend_text.i (14), and title.i (16)}

\item{figure.c}{Character: either 'interactive' for interactive display,
'my_pie.pdf' for figure saving (only the extension matters), or 'none'
to prevent plotting}
}
\value{
invisible ggplot2 object
}
\description{
Pie with ggplot2
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine_pda.df <- colData(sacurine.se)
sacurine_pda.df <- sacurine_pda.df[!grepl("QC", rownames(sacurine_pda.df)), ]
gg_pie(sacurine_pda.df, y.c = "gender", label.c = "value")
}
