% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_plots.R
\name{gg_boxplot}
\alias{gg_boxplot}
\title{Boxplot with ggplot2}
\usage{
gg_boxplot(
  data.tb,
  x.c = "",
  y.c = "",
  color.c = "",
  title.c = NA,
  xlab.c = NA,
  ylab.c = "",
  label.vc = "",
  palette.vc = "Set1",
  theme.c = c("default", "bw", "classic", "dark", "gray", "linedraw", "light", "minimal",
    "void")[3],
  size.ls = list(dot.n = 0.7, lab.i = 20, tick.i = 20, title.i = 20),
  figure.c = c("interactive", "my_boxplot.pdf")[1]
)
}
\arguments{
\item{data.tb}{Data frame (or tibble) containing the information}

\item{x.c}{Character: name of the column with qualitative levels}

\item{y.c}{Character: name of the column with quantitative values}

\item{color.c}{Character: optional name of the column for color information}

\item{title.c}{Character: plot title}

\item{xlab.c}{Character: x label}

\item{ylab.c}{Character: y label}

\item{label.vc}{Character (vector): either the name of a character column
from the data or a character vector of the same length as the rown number of
the data, containing the feature labeling for outlier display}

\item{palette.vc}{Character: either the name of an RColorBrewer palette
(default: 'Set1'; 'Paired' can be useful for parallel plotting) or a vector
manually defining the colors}

\item{theme.c}{character(1): name of the ggplot theme}

\item{size.ls}{List of sizes for dots (default is 0.7), labels
(default is 16), ticks (14) and title (20)}

\item{figure.c}{Character: either 'interactive' for interactive display or
'my_barplot.pdf' for figure saving (only the extension matters)}
}
\value{
character vector of outlier labels (same dimension as the number of
rows from data.tb)
}
\description{
Boxplot with ggplot2
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine_pda.df <- as.data.frame(colData(sacurine.se))
sacurine_pda.df <- sacurine_pda.df[!grepl("QC", rownames(sacurine_pda.df)), ]
gg_boxplot(sacurine_pda.df, y.c = "age")
gg_boxplot(sacurine_pda.df, x.c = "gender", y.c = "bmi", color.c = "gender")
gg_boxplot(sacurine_pda.df, x.c = "gender", y.c = "bmi", color.c = "gender",
label.vc = rownames(sacurine_pda.df))
}
