% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseDataset.R
\name{collapseDataset}
\alias{collapseDataset}
\title{Collapse dataset}
\usage{
collapseDataset(
  es,
  isRows = TRUE,
  selectOne = FALSE,
  fn,
  fields,
  removeEmpty = TRUE
)
}
\arguments{
\item{es}{Expression set}

\item{isRows}{Work with rows. False if columns (default True - row mode)}

\item{selectOne}{select best match or merge duplicates}

\item{fn}{select/merge function}

\item{fields}{fields to unique on}

\item{removeEmpty}{remove unannotated genes}
}
\value{
Nothing. Collapsed dataset will be assigned to es in environment
}
\description{
\code{collapseDataset} performs a collapse action on expression set
}
\examples{
\dontrun{
es <- getGSE('GSE53986')[[1]]
collapseDataset(es, isRows = TRUE, selectOne = TRUE,
fn = mean, fields = c('Gene ID', 'Gene symbol'))
}
}
\keyword{internal}
