% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{theme_ggplot2}
\alias{theme_ggplot2}
\title{Personal ggplot2 theming function, adapted from roboto-condensed 
at https://github.com/hrbrmstr/hrbrthemes/}
\usage{
theme_ggplot2(
  grid = TRUE,
  border = TRUE,
  base_size = 8,
  plot_title_size = 12,
  plot_title_face = "plain",
  plot_title_margin = 5,
  subtitle_size = 11,
  subtitle_face = "plain",
  subtitle_margin = 5,
  strip_text_size = 10,
  strip_text_face = "bold",
  caption_size = 9,
  caption_face = "plain",
  caption_margin = 3,
  axis_text_size = base_size,
  axis_title_size = 9,
  axis_title_face = "plain",
  axis_title_just = "rt",
  panel_spacing = grid::unit(2, "lines"),
  grid_col = "#cccccc",
  plot_margin = margin(12, 12, 12, 12),
  axis_col = "#cccccc",
  axis = FALSE,
  ticks = FALSE
)
}
\arguments{
\item{grid}{panel grid (`TRUE`, `FALSE`, or a combination of 
`X`, `x`, `Y`, `y`)}

\item{border}{border if `TRUE` add border}

\item{base_size}{base font size}

\item{plot_title_size, plot_title_margin, }{plot title size and margin}

\item{plot_title_face, }{plot title face}

\item{subtitle_face, subtitle_size}{plot subtitle face and size}

\item{subtitle_margin}{plot subtitle margin bottom (single numeric value)}

\item{strip_text_face, strip_text_size}{facet label font face and size}

\item{caption_face, caption_size, caption_margin}{plot caption face, size 
and margin}

\item{axis_text_size}{font size of axis text}

\item{axis_title_face, axis_title_size}{axis title font face and size}

\item{axis_title_just}{axis title font justificationk one of `[blmcrt]`}

\item{panel_spacing}{panel spacing (use `unit()`)}

\item{grid_col}{grid color}

\item{plot_margin}{plot margin (specify with [ggplot2::margin])}

\item{axis_col}{axis color}

\item{axis}{add x or y axes? `TRUE`, `FALSE`, "`xy`"}

\item{ticks}{ticks if `TRUE` add ticks}
}
\value{
theme A ggplot theme
}
\description{
Personal ggplot2 theming function, adapted from roboto-condensed 
at https://github.com/hrbrmstr/hrbrthemes/
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  labs(x="Fuel effiency (mpg)", y="Weight (tons)",
       title="Seminal ggplot2 scatterplot example") +
  theme_ggplot2()
}
