% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUI_utils.R
\name{spectraPaths_and_metadata_UI_helper}
\alias{spectraPaths_and_metadata_UI_helper}
\title{UI data import helper - prepare file paths and metadata}
\usage{
spectraPaths_and_metadata_UI_helper(
    spectraPaths = NULL,
    spectraMetadataPath = NULL
)
}
\arguments{
\item{spectraPaths}{NULL or character vector of spectra file paths, to set
samples to process}

\item{spectraMetadataPath}{NULL or path to a csv of spectra metadata, with
spectra as row and metadata as columns. (spectraPaths in column `filepath`)}
}
\value{
spectraPaths (str) and spectraMetadata (DataFrame or NULL) read from
the CSV file
}
\description{
Return spectraPaths and spectraMetadata from a .csv file (if available).
If reading from the spectraMetadata file, the spectraPaths are taken from
the `filepath` column
}
\examples{
## Input data
# spectraPath
input_spectraPaths    <- c('./path/file1', './path/file2', './path/file3')

# spectraMetadata
input_spectraMetadata <- data.frame(matrix(data=c(input_spectraPaths,
                            c('a','b','c')), nrow=3, ncol=2,
                            dimnames=list(c(),c('filepath', 'testcol')),
                            byrow=FALSE), stringsAsFactors=FALSE)

# temporary file location
spectraMetaPath <- tempfile(pattern="file", tmpdir=tempdir(), fileext='.csv')
# save csv
utils::write.csv(input_spectraMetadata,
                    file=spectraMetaPath,
                    row.names=FALSE)

# load data from CSV
spectraPaths_and_metadata_UI_helper(spectraPaths = NULL,
                                    spectraMetadataPath = spectraMetaPath)
}
