% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateFIR.R
\name{integrateFIR}
\alias{integrateFIR}
\title{Integrate fallback integration regions}
\usage{
integrateFIR(rawSpec, FIR, foundPeakTable, verbose = TRUE)
}
\arguments{
\item{rawSpec}{an \code{\link[MSnbase]{OnDiskMSnExp-class}}}

\item{FIR}{(data.frame) Fallback Integration Regions (FIR) to integrate when
a feature is not found. Compounds as row are identical to the targeted
features, columns are \code{rtMin} (float in seconds), \code{rtMax} (float in
seconds), \code{mzMin} (float), \code{mzMax} (float)}

\item{foundPeakTable}{a \code{data.frame} as generated by
\link{findTargetFeatures}, with features as rows and peak properties as
columns. The following columns are mandatory: \code{found}, \code{is_filled},
\code{mz}, \code{mzMin}, \code{mzMax}, \code{rt}, \code{rtMin}, \code{rtMax},
\code{peakArea}, \code{peakAreaRaw}, \code{maxIntMeasured},
\code{maxIntPredicted}.}

\item{verbose}{(bool) if TRUE message progress}
}
\value{
an updated foundPeakTable with FIR integration values
}
\description{
Integrate region defined in FIR if a feature is not found
}
