% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUI_utils.R
\name{annotation_fit_summary_UI_helper}
\alias{annotation_fit_summary_UI_helper}
\title{UI diagnostic table - fit summary}
\usage{
annotation_fit_summary_UI_helper(annot)
}
\arguments{
\item{annot}{(peakPantheRAnnotation) Annotation object}
}
\value{
(data.frame) Fit statistics
}
\description{
Return a table of fit statistic (ratio of peaks found, ratio of peaks filled,
ppm error, RT deviation)
}
\examples{
## Initialise a peakPantheRAnnotation object with 3 samples and 2 targeted
## compounds

# Paths to spectra files
spectraPaths <- c('./path/file1', './path/file2', './path/file3')

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

emptyAnnotation <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                        targetFeatTable=targetFeatTable)

# statistics of an empty annotation
annotation_fit_summary_UI_helper(emptyAnnotation)
#              Ratio peaks found (\%) Ratio peaks filled (\%) ppm error
# ID-1 - Cpd 1                    NA                      0       NaN
# ID-2 - Cpd 2                    NA                      0       NaN
#               RT deviation (s)
# ID-1 - Cpd 1               NaN
# ID-2 - Cpd 2               NaN
}
