% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDataStructure.R
\name{checkDataStructure}
\alias{checkDataStructure}
\title{Control structure of peakCombiner data structure}
\usage{
checkDataStructure(data, showMessages = TRUE)
}
\arguments{
\item{data}{A tibble with the columns \code{chrom}, \code{start}, \code{end}, \code{name},
\code{score}, \code{strand}, \code{center}, \code{sample_name}. Additional columns are tolerated.}

\item{showMessages}{Logical value of TRUE (default) or FALSE. Defines if
info messages are displayed or not.}
}
\value{
A tibble with the columns \code{chrom}, \code{start}, \code{end}, \code{name}, \code{score},
\code{strand}, \code{center}, \code{sample_name}. The definitions of these columns are
described in full in the Details below. Use as input for functions
\code{\link[=centerExpandRegions]{centerExpandRegions()}}, \code{\link[=filterRegions]{filterRegions()}} and
\code{\link[=combineRegions]{combineRegions()}}.
}
\description{
This is a general helper function for the package \pkg{peakCombiner}. Aim of
this function is to check a data frame for the correct column names and
classes of each column to ensure to be an accepte inpuut for functions:
\code{\link[=centerExpandRegions]{centerExpandRegions()}}, \code{\link[=filterRegions]{filterRegions()}} and
\code{\link[=combineRegions]{combineRegions()}}.
}
