\name{AffySNPCNVPDInfoPkgSeed-class}
\Rdversion{1.1}
\docType{class}
\alias{AffySNPCNVPDInfoPkgSeed-class}
%% \alias{chipName,AffySNPCNVPDInfoPkgSeed-method}
%% \alias{getGeometry,AffySNPCNVPDInfoPkgSeed-method}
%% \alias{makePdInfoPackage,AffySNPCNVPDInfoPkgSeed-method}


\title{Class "AffySNPCNVPDInfoPkgSeed"}
\description{
  This class represents Platform Design (PD) packages for Affymetrix
  genomewide (SNP 5.0 and SNP 6.0) arrays.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("AffySNPCNVPDInfoPkgSeed", cdfFile, csvAnnoFile, csvSeqFile, csvAnnoFileCnv, csvSeqFileCnv, splineParamFile, crlmmInfoFile, referenceDistFile, ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{cdfFile}:}{Path to the CDF file for this.}
    \item{\code{csvAnnoFile}:}{Path to the Affymetrix CSV annotation for
      the SNP probes.}
    \item{\code{csvSeqFile}:}{Path to the (SNP) probe sequence file.}
    \item{\code{csvAnnoFileCnv}:}{Path to the Affymetrix CSV annotation
      for the CNV probes.}
    \item{\code{csvSeqFileCnv}:}{Path to the (CNV) probe sequence file.}
    \item{\code{splineParamFile}:}{Path to the spline parameters file used to
      compute the predicted accuracy of the the genotype calls.  Used
      internally in \code{.predictAccuracy}.}
    \item{\code{crlmmInfoFile}:}{Path to is data file containing regions data
      used by the \code{crlmm} function.}
    \item{\code{referenceDistFile}:}{Path to a reference distribution file used
      in the normalization step. This is the reference used in \code{snprma}.}
    \item{\code{chipName}:}{Name of the chip or platform}
    \item{\code{manufacturer}:}{chip/platform manufacturer}
    \item{\code{url}:}{chip URL}
    \item{\code{genomebuild}:}{The genome build this platform is based
      upon.}
    \item{\code{organism}:}{ organism for chip. }
    \item{\code{species}:}{ species for chip. }  
    \item{\code{version}:}{A character vector giving the version
    number of the package.}
    \item{\code{license}:}{The license of the package}
    \item{\code{author}:}{Author of the package}
    \item{\code{email}:}{An email address to use in the Maintainer field}
    \item{\code{biocViews}:}{Character data for the biocViews field of
      the DESCRIPTION file}
  }
}
\section{Methods}{
  \describe{
    \item{chipName}{\code{signature(object = "AffySNPCNVPDInfoPkgSeed")}: ... }
    \item{getGeometry}{\code{signature(object = "AffySNPCNVPDInfoPkgSeed")}: ... }
    \item{makePdInfoPackage}{\code{signature(object = "AffySNPCNVPDInfoPkgSeed")}: ... }
  }
}


\section{Notes}{
  *IMPORTANT* Users are strongly advised to download Affymetrix SNP
  packages from BioConductor.
  
  The files used for slots \code{splineParamFile}, \code{crlmmInfoFile},
  and \code{referenceDistFile} are generated by the Bioconductor project
  for each chip/platform and are hosted in our svn data repository at
  \url{https://hedgehog.fhcrc.org/bioc-data/trunk/annotation/parms_store}.
  When \code{makePdInfoPackage} is run, these files are simply copied to
  the \code{inst/extdata} directory of the generated package.
}

\author{Benilton Carvalho}

\examples{
showClass("AffySNPCNVPDInfoPkgSeed")
}
\keyword{classes}
