% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesPC_calculate_AESPCA.R
\name{aespca}
\alias{aespca}
\title{Adaptive, elastic-net, sparse principal component analysis}
\usage{
aespca(X, d = 1, max.iter = 10, eps.conv = 0.001, adaptive = TRUE, para = NULL)
}
\arguments{
\item{X}{A pathway design matrix: the data matrix should be \eqn{n \times p},
where \eqn{n} is the sample size and \eqn{p} is the number of variables
included in the pathway.}

\item{d}{The number of principal components (PCs) to extract from the
pathway. Defaults to 1.}

\item{max.iter}{The maximum number of times an internal \code{while()} loop
can make calls to the \code{lars.lsa()} function. Defaults to 10.}

\item{eps.conv}{A numerical convergence threshold for the same \code{while()}
loop. Defaults to 0.001.}

\item{adaptive}{Internal argument of the \code{lars.lsa()} function. Defaults
to TRUE.}

\item{para}{Internal argument of the \code{lars.lsa()} function. Defaults to
NULL.}
}
\value{
A list of four elements containing the loadings and projected
  predictors:
  \itemize{
    \item{\code{aesLoad} : }{A \eqn{d \times p} projection matrix of the
       \eqn{d} AES-PCs.}
    \item{\code{oldLoad} : }{A \eqn{d \times p} projection matrix of the
       \eqn{d} PCs from the singular value decomposition (SVD).}
    \item{\code{aesScore} : }{An \eqn{n \times d} predictor matrix: the
       original \eqn{n} observations loaded onto the \eqn{d} AES-PCs.}
    \item{\code{oldScore} : }{An \eqn{n \times d} predictor matrix: the
       original \eqn{n} observations loaded onto the \eqn{d} SVD-PCs.}
  }
}
\description{
A function to perform adaptive, elastic-net, sparse principal
  component analysis (AES-PCA).
}
\details{
This function calculates the loadings and reduced-dimension
   predictor matrix using both the Singular Value Decomposition and AES-PCA
   Decomposition (as described in Efron et al (2003)) of the data matrix.
   Note that, if the number of features in the pathway exceeds the number of
   samples, this decompostion will be an approximation; also, the internal
   \code{\link{lars.lsa}} function may require more computing time than usual
   to converge (which is one of the reasons why, in practice, we usually
   remove pathways that have more than 200-300 features).

   See \url{https://web.stanford.edu/~hastie/Papers/LARS/LeastAngle_2002.pdf}.

   For potential enhancement details, see the comment in the "Details"
   section of \code{\link{normalize}}.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Call this function through AESPCA_pVals() instead.

\dontrun{
  data("colonSurv_df")
  aespca(as.matrix(colonSurv_df[, 5:50]))
}

}
\seealso{
\code{\link{normalize}}; \code{\link{lars.lsa}};
   \code{\link{ExtractAESPCs}}; \code{\link{AESPCA_pVals}}
}
