% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superPC_wrapper.R
\name{SuperPCA_pVals}
\alias{SuperPCA_pVals}
\alias{SuperPCA_pVals,OmicsPathway-method}
\title{Test pathways with Supervised PCA}
\usage{
SuperPCA_pVals(
  object,
  n.threshold = 20,
  numPCs = 1,
  parallel = FALSE,
  numCores = NULL,
  adjustpValues = TRUE,
  adjustment = c("Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BH", "BY",
    "ABH", "TSBH"),
  ...
)

\S4method{SuperPCA_pVals}{OmicsPathway}(
  object,
  n.threshold = 20,
  numPCs = 1,
  parallel = FALSE,
  numCores = NULL,
  adjustpValues = TRUE,
  adjustment = c("Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BH", "BY",
    "ABH", "TSBH"),
  ...
)
}
\arguments{
\item{object}{An object of superclass \code{OmicsPathway} with a response
matrix or vector.}

\item{n.threshold}{The number of bins into which to split the feature scores
in the fit object returned internally by the \code{\link{superpc.train}}
function to the \code{\link{pathway_tScores}} and
\code{\link{pathway_tControl}} functions. Defaults to 20. Smaller values
may result in less accurate pathway \eqn{p}-values while larger values
increase computation time.}

\item{numPCs}{The number of PCs to extract from each pathway. Defaults to 1.}

\item{parallel}{Should the computation be completed in parallel? Defaults to
\code{FALSE}.}

\item{numCores}{If \code{parallel = TRUE}, how many cores should be used for
computation? Internally defaults to the number of available cores minus 1.}

\item{adjustpValues}{Should you adjust the \eqn{p}-values for multiple
comparisons? Defaults to TRUE.}

\item{adjustment}{Character vector of procedures. The returned data frame
will be sorted in ascending order by the first procedure in this vector,
with ties broken by the unadjusted \eqn{p}-value. If only one procedure is
selected, then it is necessarily the first procedure. See the documentation
for the \code{\link{ControlFDR}} function for the adjustment procedure
definitions and citations.}

\item{...}{Dots for additional internal arguments.}
}
\value{
A data frame with columns:
\itemize{
  \item{\code{pathways} : }{The names of the pathways in the \code{Omics*}}
    object (given in \code{object@trimPathwayCollection$pathways}.)
  \item{\code{setsize} : }{The number of genes in each of the original
    pathways (given in the \code{object@trimPathwayCollection$setsize}
    object).}
  \item{\code{terms} : }{The pathway description, as given in the
    \code{object@trimPathwayCollection$TERMS} object.}
  \item{\code{rawp} : }{The unadjusted \eqn{p}-values of each pathway.}
  \item{\code{...} : }{Additional columns as specified through the
    \code{adjustment} argument.}
}

The data frame will be sorted in ascending order by the method specified
  first in the \code{adjustment} argument. If \code{adjustpValues = FALSE},
  then the data frame will be sorted by the raw \eqn{p}-values. If you have
  the suggested \code{tidyverse} package suite loaded, then this data frame
  will print as a \code{\link[tibble]{tibble}}. Otherwise, it will print as
  a data frame.
}
\description{
Given a supervised \code{OmicsPath} object (one of
   \code{OmicsSurv}, \code{OmicsReg}, or \code{OmicsCateg}), extract the
   first \eqn{k} principal components (PCs) from each pathway-subset of the
   -Omics assay design matrix, test their association with the response
   matrix, and return a data frame of the adjusted \eqn{p}-values for each
   pathway.
}
\details{
This is a wrapper function for the \code{\link{pathway_tScores}},
  \code{\link{pathway_tControl}}, \code{\link{OptimGumbelMixParams}},
  \code{\link{GumbelMixpValues}}, and \code{\link{TabulatepValues}}
  functions.

  Please see our Quickstart Guide for this package:
  \url{https://gabrielodom.github.io/pathwayPCA/articles/Supplement1-Quickstart_Guide.html}
}
\examples{
  ###  Load the Example Data  ###
  data("colonSurv_df")
  data("colon_pathwayCollection")

  ###  Create an OmicsSurv Object  ###
  colon_OmicsSurv <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "surv"
  )

  ###  Calculate Pathway p-Values  ###
  colonSurv_superpc <- SuperPCA_pVals(
    object = colon_OmicsSurv,
    parallel = TRUE,
    numCores = 2,
    adjustpValues = TRUE,
    adjustment = c("Hoch", "SidakSD")
  )

}
\seealso{
\code{\link{CreateOmics}}; \code{\link{TabulatepValues}};
   \code{\link{pathway_tScores}}; \code{\link{pathway_tControl}};
   \code{\link{OptimGumbelMixParams}}; \code{\link{GumbelMixpValues}};
   \code{\link[parallel]{clusterApply}}
}
