% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesPC_permtest_GLM.R
\name{PermTestCateg}
\alias{PermTestCateg}
\alias{PermTestCateg,OmicsCateg-method}
\title{AES-PCA permutation test of categorical response for pathway PCs}
\usage{
PermTestCateg(
  OmicsCateg,
  pathwayPCs_ls,
  numReps = 0L,
  parallel = FALSE,
  numCores = NULL,
  ...
)

\S4method{PermTestCateg}{OmicsCateg}(
  OmicsCateg,
  pathwayPCs_ls,
  numReps = 0L,
  parallel = FALSE,
  numCores = NULL,
  ...
)
}
\arguments{
\item{OmicsCateg}{A data object of class \code{OmicsCateg}, created by the
\code{\link{CreateOmics}} function.}

\item{pathwayPCs_ls}{A list of pathway PC matrices returned by the
\code{\link{ExtractAESPCs}} function.}

\item{numReps}{How many permutations to estimate the \eqn{p}-value? Defaults
to 0 (that is, to estimate the \eqn{p}-value parametrically). If
\code{numReps} > 0, then the non-parametric, permutation \eqn{p}-value
will be returned based on the number of random samples specified.}

\item{parallel}{Should the computation be completed in parallel? Defaults to
\code{FALSE}.}

\item{numCores}{If \code{parallel = TRUE}, how many cores should be used for
computation? Internally defaults to the number of available cores minus 2.}

\item{...}{Dots for additional internal arguments (currently unused).}
}
\value{
A named vector of pathway permutation \eqn{p}-values.
}
\description{
Given an \code{OmicsCateg} object and a list of pathway PCs from
  the \code{\link{ExtractAESPCs}} function, test if each pathway with
  features recorded in the bio-assay design matrix is significantly related
  to the categorical response.
}
\details{
This function takes in a list of the first principal components
  from each pathway and an object of class \code{OmicsCateg}. This function
  will then calculate the AIC of a multivariate generalized linear model (via
  the \code{\link[stats]{glm}} function with a \code{\link[stats]{binomial}}
  error family) with the original observations as response and the pathway
  principal components as the predictor matrix.

  Then, this function will create \code{numReps} permutations of the
  categorical response, fit models to each of these permuted responses
  (holding the path predictor matrix fixed), and calculate the AIC of each
  model. This function will return a named vector of permutation
  \eqn{p}-values, where the value for each pathway is the proportion of
  models for which the AIC of the permuted response model is less than the
  AIC of the original model.  Note that the AIC and log-likelihood are
  proportional because the number of parameters in each pathway is constant.

  In future versions, this function will also be able to calculate permuted
  \eqn{p}-values for multinomial logistic regression and proportional odds
  logistic regression models, for n-ary and ordered categorical responses,
  respectively.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Use AESPCA_pVals() instead

\dontrun{
  ###  Load the Example Data  ###
  data("colonSurv_df")
  data("colon_pathwayCollection")

  ###  Create an OmicsSurv Object  ###
  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, c(1,3)],
    respType = "categ"
  )

  ###  Extract Pathway PCs and Loadings  ###
  colonPCs_ls <- ExtractAESPCs(
    object = colon_Omics,
    parallel = TRUE,
    numCores = 2
  )

  ###  Pathway p-Values  ###
  PermTestCateg(
    OmicsCateg = colon_Omics,
    pathwayPCs_ls = colonPCs_ls$PCs,
    parallel = TRUE,
    numCores = 2
  )
}

}
\seealso{
\code{\link{CreateOmics}}; \code{\link{ExtractAESPCs}};
  \code{\link[stats]{glm}}; \code{\link[stats]{binomial}};
  \code{\link{SampleCateg}}
}
\keyword{internal}
