% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissectDB.R
\name{dissectDB}
\alias{dissectDB}
\title{Split pathways into coexpressed subpathways}
\usage{
dissectDB(
  refObject,
  geneSets,
  minPathSize = 10,
  minSplitSize = 3,
  maxSplits = NULL,
  explainedVariance = 60,
  percSharedGenes = 90,
  use.assay = 1
)
}
\arguments{
\item{refObject}{A refObject object structure: a list of lists, each one
with a
cases omic matrix and controls omic matrix
(named as Disease and Healthy). It can be constructed with the buildRefObject
 function. A list with one or more expression matrices, ExpressionSets or
 SummarizedExperiments without controls, can also be used. Data should be
 normalized and log2-transformed. Feature names must match the gene sets 
 nomenclature. To use
preloaded databases, they must be gene symbols.}

\item{geneSets}{A named list with each gene set,
or the name of one preloaded database (go_bp, go_cc, go_mf, kegg, reactome,
pharmgkb, lincs, ctd, disgenet, hpo, wikipathways, tmod)
or a GeneSetCollection.}

\item{minPathSize}{numeric, minimum number of genes in a pathway to consider
splitting it.}

\item{minSplitSize}{numeric, minimum number of genes in a subpathway.
Smaller splits will be merged with the closest coexpressed subpathway.}

\item{maxSplits}{numeric, maximum number of subpathways for a pathway. If
NULL (default), there is not limit.}

\item{explainedVariance}{numeric, percentage of cumulative variance explained
within a pathway. This parameter is used to select the number of subdivisions
of a pathway that manage to explain at least the percentage of variance
defined by explainedVariance.}

\item{percSharedGenes}{numeric, minimum percentage of common genes across
datasets to merge them before clustering. If NULL or this percentage is not
reached, clustering is performed for each dataset independently and
consensus subpathways are obtained from co-occurrence across datasets.}

\item{use.assay}{If SummarizedExperiments are used, the number of the assay 
to extract the data.}
}
\value{
A list with the subpathways.
}
\description{
Split pathways into coexpressed subpathways
}
\examples{
data(refData)

refObject <- buildRefObject(
    data = list(
        refData$dataset1, refData$dataset2,
        refData$dataset3, refData$dataset4
    ),
    metadata = list(
        refData$metadata1, refData$metadata2,
        refData$metadata3, refData$metadata4
    ),
    groupVar = "group",
    controlGroup = "Healthy_sample"
)

set.seed(123)
custom.tmod <- dissectDB(refObject, geneSets = "tmod")
}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{buildRefObject}}, \code{\link{mScores_createReference}},
 \code{\link{getScores}}
}
\author{
Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
