% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRCs.R
\name{splitROIs}
\alias{splitROIs}
\title{Split (larger) ROIs into multiple smaller (overlapping) bins and create 
new BED file}
\usage{
splitROIs(oldBedFile, newBedFile, limit = 0, bin = 100, shift = 50,
  chr = FALSE)
}
\arguments{
\item{oldBedFile}{filename of the BED file with absolute or relative path
(structure of BED file without header: chromosome, exon start, exon end,
exon name)}

\item{newBedFile}{filename of the new BED file that should be created}

\item{limit}{ROIs larger than limit will be split}

\item{bin}{size of bins (in bp) the ROIs will be split into}

\item{shift}{no. of bp between start positions of adjacent bins}

\item{chr}{indicates whether naming contains chr prefix}
}
\value{
generates a new BED file with (larger) ROIs split into smaller bins
}
\description{
Split (larger) ROIs into multiple smaller (overlapping) bins and create 
new BED file
}
\examples{
bed <- list.files(system.file("extdata", package = "panelcn.mops"),
                    pattern = ".bed$", full.names = TRUE)
splitROIs(bed, "newBed.bed")
}
