% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_functions.R
\name{subnetwork}
\alias{subnetwork}
\title{Subnetwork}
\usage{
subnetwork(x, nodes, subTf = TRUE)
}
\arguments{
\item{x}{an object of class "panda"}

\item{nodes}{character vector containing the transcription factor or gene labels to subset}

\item{subTf}{an optional logical indicating whether to subset by transcription factor.  Default is TRUE.}
}
\value{
An matrix describing the subsetted bipartite network.
}
\description{
subnetwork gets a bipartite network containing only the transcription factors or genes and their respective connections
}
\examples{
\donttest{
data(pandaToyData)
pandaRes <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.001,progress=TRUE)
topPandaRes <- topedges(pandaRes,1000)
subnet.pandaRes <- subnetwork(topPandaRes,c("AR","ARID3A","ELK1"))
}
data(pandaResult)
topPandaRes <- topedges(pandaResult,1000)
subnetwork(topPandaRes,c("AR","ARID3A","ELK1"))
}
\keyword{keywords}
