% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotZbyTF}
\alias{plotZbyTF}
\title{Plot Z by TF out-degree quantiles}
\usage{
plotZbyTF(x, y, motif, hasPrior = TRUE, cuts = 1, cols = 2)
}
\arguments{
\item{x}{PANDA object - output of the \code{panda} function.}

\item{y}{PANDA object - second PANDA object.}

\item{motif}{Motif used to construct the networks.}

\item{hasPrior}{TRUE/FALSE, If TRUE plots the edges that are given a weight > 0 in the motif,
else plot those given a weight of 0}

\item{cuts}{either a numeric vector of two or more unique cut points or a
single number (greater than or equal to 2) giving the number
of intervals into which 'x' is to be cut.}

\item{cols}{Number of columns in layout.}
}
\value{
ggplot heatmapfor each TF, get outdegree in regulatory prior
}
\description{
Generates a Z-score scatterplot for edges according to the TF outdegree in prior.
The two PANDA objects should only differ in the gene expression used for the network 
constructions or other parameters.
}
\examples{

data(pandaResult)
data(pandaToyData)
plotZbyTF(pandaResult,pandaResult, pandaToyData$motif, hasPrior=TRUE)
plotZbyTF(pandaResult,pandaResult, pandaToyData$motif, cuts=2)

}
