% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotZ}
\alias{plotZ}
\title{Comparison of Z scores between two PANDA runs}
\usage{
plotZ(x, y, hex = TRUE, bins = 200, addLine = TRUE, rank = FALSE)
}
\arguments{
\item{x}{PANDA object - output of the \code{panda} function.}

\item{y}{PANDA object - second PANDA object.}

\item{hex}{TRUE/FALSE - If TRUE, bin data points to avoid over plotting.}

\item{bins}{Number of bins to use for plotting.}

\item{addLine}{TRUE/FALSE - to add y=x line.}

\item{rank}{TRUE/FALSE - If TRUE, plot rank of edge weights rather than weight values.}
}
\value{
ggplot comparing the Z-scores between the two networks.
}
\description{
Given two PANDA objects with the same network structure, plot the Z-score comparison.
The two PANDA objects should only differ in the gene expression used for the network 
constructions or other parameters.
}
\examples{

data(pandaResult)
data(pandaToyData)
pandaRes <- pandaRes2 <- pandaResult
plotZ(pandaRes, pandaRes2)

\donttest{
panda.res1 <- with(pandaToyData, panda(motif, expression, ppi, hamming=1))
panda.res2 <- with(pandaToyData, panda(motif, expression + 
                   rnorm(prod(dim(expression)),sd=5), ppi, hamming=1))
plotZ(panda.res1, panda.res2,addLine=FALSE)
}

}
