% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotCommunityDetection}
\alias{plotCommunityDetection}
\title{Community detection plot}
\usage{
plotCommunityDetection(x, scaleEdge = 5, verbose = TRUE, ...)
}
\arguments{
\item{x}{Toy PANDA output represented as a TF, Gene, and Score.}

\item{scaleEdge}{Visualization parameter for the edges.}

\item{verbose}{TRUE/FALSE - Report community structure.}

\item{...}{Options for the plot function.}
}
\value{
Optionally return a list with the graph and community.
}
\description{
This function performs community detection on an undirected PANDA network.
The function optionally returns the graph and community.
}
\examples{

# start with some toy PANDA output
mat <- cbind(rep(1:5, each=10), rep(seq(11,20),5), sample(100, 50)/100)
x =plotCommunityDetection(mat)
str(x)

#example of very different edges
set.seed(1)
subst <- sample(50,10)
mat[subst, 3] <- subst
plotCommunityDetection(mat,scaleEdge=0.5)

}
