% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_expmat.R
\name{time_expmat}
\alias{time_expmat}
\title{Generate Timewise Average Gene Expression}
\usage{
time_expmat(time, expmat)
}
\arguments{
\item{time}{(character) Time-annotation of samples.}

\item{expmat}{(matrix) Gene expression matrix.}
}
\value{
(matrix) Time-wise average gene expression.
}
\description{
Generate timewise average gene expression.
}
\examples{
expmat <- matrix(rnorm(90), 10, 9, dimnames=list(LETTERS[1:10], 1:9))
time <- c(rep("T1", 3), rep("T2", 3), rep("T3", 3))
time_expmat(time, expmat)

}
\author{
DING, HONGXU (hd2326@columbia.edu)
}
