% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_graph.R
\name{diff_graph}
\alias{diff_graph}
\title{Calculate Temporal PageRank from Two Graphs}
\usage{
diff_graph(graph1, graph2)
}
\arguments{
\item{graph1}{(igraph) The 1st graph.}

\item{graph2}{(igraph) The 2nd graph.}
}
\value{
(igraph) Network graph1-graph2 with "moi (mode of interaction)" and
"pagerank" as edge and vertex attributes.
}
\description{
Calculate temporal PageRank by changing edges between graph1 and graph2.
This is a simplified version of temporal PageRank described by Rozenshtein
and Gionis, by only analyzing temporally adjacent graph pairs.
}
\examples{
library(igraph)
set.seed(1)
graph1 <- igraph::erdos.renyi.game(100, 0.01, directed = TRUE)
igraph::V(graph1)$name <- 1:100
set.seed(2)
graph2 <- igraph::erdos.renyi.game(100, 0.01, directed = TRUE)
igraph::V(graph2)$name <- 1:100
diff_graph(graph1, graph2)

}
\references{
Rozenshtein, Polina, and Aristides Gionis. "Temporal pagerank."
Joint European Conference on Machine Learning and Knowledge Discovery in
Databases. Springer, Cham, 2016.
}
\author{
DING, HONGXU (hd2326@columbia.edu)
}
