% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary,padmaResults-method}
\alias{summary,padmaResults-method}
\alias{summary}
\alias{summary-methods}
\title{Summarize results from padma}
\usage{
\S4method{summary}{padmaResults}(object, ...)
}
\arguments{
\item{object}{An object of class \code{'padmaResults'}}

\item{...}{Additional arguments}
}
\value{
Summary of the \code{padmaResults} object.
}
\description{
A function to summarize the pathway deviation results from \code{padma}, 
using the quantiles of the calculated multi-omic pathway deviation scores.
}
\examples{

LUAD_subset <- padma::LUAD_subset
## Create MultiAssayExperiment object with LUAD data
omics_data <- 
  list(rnaseq = as.matrix(LUAD_subset$rnaseq),
       methyl = as.matrix(LUAD_subset$methyl),
       mirna = as.matrix(LUAD_subset$mirna),
       cna = as.matrix(LUAD_subset$cna))
pheno_data <- 
  data.frame(LUAD_subset$clinical, 
             row.names = LUAD_subset$clinical$bcr_patient_barcode)
mae <-
  suppressMessages(
    MultiAssayExperiment::MultiAssayExperiment(
      experiments = omics_data, colData = pheno_data))

## Run padma
run_padma <- 
  padma(mae, gene_map = padma::mirtarbase,
        pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY", verbose = FALSE)

summary(run_padma)

## padma plots
\dontrun{
factorMap(run_padma, dim_x = 1, dim_y = 2)
factorMap(run_padma, dim_x = 1, dim_y = 2,
           partial_id = "TCGA-78-7536")
omicsContrib(run_padma, max_dim = 10)
}
}
\references{
Rau, A., Manansala, R., Flister, M. J., Rui, H., Jaffrézic, F., Laloë, D., 
and  Auer, P. L. (2019) Individualized multi-omic pathway deviation scores 
using multiple factor analysis bioRxiv, https://doi.org/10.1101/827022.
}
\seealso{
\code{\link{padma}}
}
\author{
Andrea Rau
}
\keyword{methods}
