% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllGenerics.R, R/methods.R
\docType{methods}
\name{padma}
\alias{padma}
\alias{padma,list-method}
\alias{padma-methods}
\alias{padma,MultiAssayExperiment-method}
\title{Calculate individualized deviation scores from multi-omic data}
\usage{
padma(object, ...)

\S4method{padma}{list}(
  object,
  colData,
  gene_map = padma::mirtarbase,
  base_ids = NULL,
  supp_ids = NULL,
  pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY",
  impute = FALSE,
  variance_threshold = 1e-04,
  full_results = TRUE,
  verbose = TRUE,
  ...
)

\S4method{padma}{MultiAssayExperiment}(
  object,
  gene_map = padma::mirtarbase,
  base_ids = NULL,
  supp_ids = NULL,
  pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY",
  impute = FALSE,
  variance_threshold = 1e-04,
  full_results = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Matched multi-omic data. May be provided as (1) a 
\code{MultiAssayExperiment} or (2) a named \code{list}, with each
element corresponding to a \code{matrix} representing an omic, with 
biological entities in rows. Row names should include unique biological 
entity IDs (e.g., gene symbols, miRNA names); columns represent 
individuals. If more than one biological entity is used, a 
\code{gene_map} data.frame providing mappings between IDs and gene
names should be provided if the default \code{mirtarbase} is not 
sufficient.}

\item{...}{Optional additional arguments}

\item{colData}{(optional) A \code{DataFrame} or \code{data.frame} of 
characteristics for all biological units, to be used in creating a 
\code{MultiAssayExperiment} from an  \code{object} of class \code{list}}

\item{gene_map}{(optional) Data frame mapping
arbitrary biological entities (e.g. miRNAs) to genes. Contains two columns, 
where the first provides the IDs of the entity and
the second provides the IDs of the corresponding target gene.
By default, the miRNA-gene interactions of type 'Functional MTI' from 
miRTarBase are used (see the preloaded \code{'mirtarbase'} data in the 
package).}

\item{base_ids}{(optional) Sample names to be used as reference base data.
By default, all samples are used.}

\item{supp_ids}{(optional) Sample names to be used as supplementary 
individuals to be
projected onto the analysis based on the individuals identified in 
\code{base_ids}. By default, takes the value \code{NULL}, but should not 
overlap with \code{base_ids} if provided by the user.}

\item{pathway_name}{Character of either a KEGG pathway identifier or MSigDB 
pathway names (e.g., see the pathway names in the \code{'geneset'} column of 
the preloaded \code{msigdb} data in the package), or a vector of gene 
symbols.}

\item{impute}{If \code{TRUE}, impute missing values separately in base and
supplementary data using MFA as implemented in the \emph{missMDA} package; 
otherwise simple mean imputation is used (default).}

\item{variance_threshold}{Minimal variance required across samples to retain 
a biological entity in the analysis}

\item{full_results}{If \code{TRUE} (default), include full MFA results in 
function output; otherwise, provide concise output to save space.}

\item{verbose}{If \code{TRUE}, provide verbose output.}
}
\value{
An S4 object of class \code{padmaResults}, where individualized pathway 
deviation scores are stored as the assay data, and the corresponding 
\{pathway name, full MFA results, number of genes, and names of imputed 
or filtered genes\} are stored as slots that can be retrieved using
the appropriate accessor functions.
}
\description{
This is the primary user interface for the \code{padma} package.
Generic S4 methods are implemented to calculate individualized pathway
deviation scores on the basis of matched, multi-omic data.
The supported classes for input are \code{list} and 
\code{MultiAssayExperiment}. The output of \code{padma} is an S4 object of 
class \code{padmaResults}.
}
\examples{

LUAD_subset <- padma::LUAD_subset
## Create MultiAssayExperiment object with LUAD data
omics_data <- 
  list(rnaseq = as.matrix(LUAD_subset$rnaseq),
       methyl = as.matrix(LUAD_subset$methyl),
       mirna = as.matrix(LUAD_subset$mirna),
       cna = as.matrix(LUAD_subset$cna))
pheno_data <- 
  data.frame(LUAD_subset$clinical, 
             row.names = LUAD_subset$clinical$bcr_patient_barcode)
mae <-
  suppressMessages(
    MultiAssayExperiment::MultiAssayExperiment(
      experiments = omics_data, colData = pheno_data))

## Run padma
run_padma <- 
  padma(mae, gene_map = padma::mirtarbase,
        pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY", verbose = FALSE)

summary(run_padma)

## padma plots
\dontrun{
factorMap(run_padma, dim_x = 1, dim_y = 2)
factorMap(run_padma, dim_x = 1, dim_y = 2,
           partial_id = "TCGA-78-7536")
omicsContrib(run_padma, max_dim = 10)
}
}
\author{
Andrea Rau
}
\keyword{methods}
