% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{omicsContrib}
\alias{omicsContrib}
\title{Plot the omics contribution per MFA axis and the overall weighted 
contribution}
\usage{
omicsContrib(
  padma_obj,
  max_dim = min(10, nrow(MFA_results(padma_obj)$eig)),
  ggplot = TRUE
)
}
\arguments{
\item{padma_obj}{Output from running the \code{padma} function
(with \code{'full_results = TRUE'})}

\item{max_dim}{Maximum dimension number of the MFA to be plotted}

\item{ggplot}{If \code{TRUE}, use \code{ggplot2} for plotting (and
\code{cowplot} for combining ggplots)}
}
\value{
Barplots of percent variance contribution, optionally of class 
\code{ggplot}.
}
\description{
Plot barplots indicating the percent contribution of each omics to each MFA 
dimension, as well as the overall weighted (by eigenvalue) percent 
contribution to the full analysis.
}
\examples{

LUAD_subset <- padma::LUAD_subset
## Create MultiAssayExperiment object with LUAD data
omics_data <- 
  list(rnaseq = as.matrix(LUAD_subset$rnaseq),
       methyl = as.matrix(LUAD_subset$methyl),
       mirna = as.matrix(LUAD_subset$mirna),
       cna = as.matrix(LUAD_subset$cna))
pheno_data <- 
  data.frame(LUAD_subset$clinical, 
             row.names = LUAD_subset$clinical$bcr_patient_barcode)
mae <-
  suppressMessages(
    MultiAssayExperiment::MultiAssayExperiment(
      experiments = omics_data, colData = pheno_data))

## Run padma
run_padma <- 
  padma(mae, gene_map = padma::mirtarbase,
        pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY", verbose = FALSE)

summary(run_padma)

## padma plots
\dontrun{
factorMap(run_padma, dim_x = 1, dim_y = 2)
factorMap(run_padma, dim_x = 1, dim_y = 2,
           partial_id = "TCGA-78-7536")
omicsContrib(run_padma, max_dim = 10)
}
}
