% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padma_data.R
\docType{data}
\name{LUAD_subset}
\alias{LUAD_subset}
\title{Subset of batch-corrected multi-omic TCGA data in lung adenocarcinoma}
\format{
A named list of five objects of class \code{data.frame}
containing a subset of the batch-corrected multi-omic TCGA
data from lung adenocarcinoma, corresponding to the 13 genes
in the D4 GDI signaling pathway:
\code{'clinical'} is of dimension 144 x 55 and contains clinical
variables for the 144 individuals. \code{'rnaseq'}, \code{'methyl'},
 \code{'cna'}, and \code{'mirna'} are of dimension 13 (genes) or 1 (miRNAs) 
 x 144 (samples), where the row names contain the gene symbol or miRNA name.
}
\source{
\href{https://www.cancer.gov/about-nci/organization/ccg/research/structural-genomics/tcga}{TCGA}
}
\usage{
data(LUAD_subset)
}
\description{
List of multi-omic (RNA-seq, copy number alterations, methylation, and
miRNA-seq) and phenotypic data in 144 individuals in the TCGA-LUAD
data for the 13 genes in the D4-GDI signaling pathway.
}
\examples{
data(LUAD_subset)
head(LUAD_subset)
}
\references{
The Cancer Genome Atlas Research Network (2014) Nature 511, 543-550.
\url{https://doi.org/10.1038/nature13385}.

Rau et al. (2019) bioRxiv, \url{https://doi.org/10.1101/827022}.
}
\keyword{datasets}
