#' @title 
#' Arabidopsis thaliana Refseq Genome Chromosome 3 Subset
#'
#' @description
#' The chromosome 3 reference sequence for Arabidopsis 
#' thaliana as a 
#' \code{\link[Biostrings:XStringSet-class]{DNAStringSet}}. 
#' Can be used as a test data set, as in the associated 
#' introduction vignette. The DNA sequence between bases 
#' 10,500,000 and 14,300,000 was extracted for use in this dataset.
#'
#' @format
#' A \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} 
#' object containing a 
#' \code{\link[Biostrings:XString-class]{DNAString}} for 
#' Arabidopsis thaliana's chromosome 3 sequence.
#'
#' @usage
#' data(arabidopsisThalianaRefseq)
#' 
#' @source
#' The Arabidopsis thaliana genome was downloaded from the 
#' NCBI refseq database on 20/SEP/2019, using 
#' \code{\link[biomartr]{getGenome}}, and chromosome 3 was 
#' extracted. The genome may also be accessed from the NCBI 
#' ftp server: \url{ftp://ftp.ncbi.nlm.nih.gov/genomes}.
#' 
#' @seealso 
#' \code{\link[biomartr]{getGenome}},
#' \code{\link[Biostrings:XStringSet-class]{DNAStringSet}},
#' \code{\link[Biostrings:XString-class]{DNAString}},
#' \code{\link{packSearch}}
#'
#' @examples
#' data(arabidopsisThalianaRefseq)
#'
#' packMatches <- packSearch(
#'     Biostrings::DNAString("CACTACAA"),
#'     arabidopsisThalianaRefseq,
#'     elementLength = c(300, 3500),
#'     tsdLength = 3
#' )
#' 
#' @author 
#' Jack Gisby

"arabidopsisThalianaRefseq"
