% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingBayes.R
\name{spatial2D}
\alias{spatial2D}
\title{Uncertainty plot in localisation probabilities}
\usage{
spatial2D(
  object,
  dims = c(1, 2),
  cov.function = fields::wendland.cov,
  theta = 1,
  derivative = 2,
  k = 1,
  breaks = c(0.99, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7),
  aspect = 0.5
)
}
\arguments{
\item{object}{A valid object of class \code{MSnset} with mcmc prediction
results from \code{tagmMCMCpredict}}

\item{dims}{The PCA dimension in which to project he data, default is
\code{c(1,2)}}

\item{cov.function}{The covariance function used default is
wendland.cov. See \code{fields} package.}

\item{theta}{A hyperparameter to the covariance function. See \code{fields}
package. Default is 1.}

\item{derivative}{The number of derivative of the wendland kernel. See
\code{fields} package. Default is 2.}

\item{k}{A hyperparamter to the covariance function. See \code{fields}
package. Default is 1.}

\item{breaks}{Probability values at which to draw the contour bands. Default
is \code{c(0.99, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7)}}

\item{aspect}{A argument to change the plotting aspect of the PCA}
}
\value{
Used for side effect of producing plot. Invisibily returns an ggplot
    object that can be further manipulated
}
\description{
Produces a pca plot with spatial variation in localisation probabilities
}
\examples{
\dontrun{
library("pRolocdata")
data("tan2009r1")

tanres <- tagmMcmcTrain(object = tan2009r1)
tanres <- tagmMcmcProcess(tanres)
tan2009r1 <- tagmMcmcPredict(object = tan2009r1, params = tanres, probJoint = TRUE)
spatial2D(object = tan2009r1)
}
}
\author{
Oliver M. Crook <omc25@cam.ac.uk>
}
