% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting2.R
\name{plot2Ds}
\alias{plot2Ds}
\alias{data1}
\alias{data2}
\alias{col1}
\alias{col2}
\title{Draw 2 data sets on one PCA plot}
\usage{
plot2Ds(
  object,
  pcol,
  fcol = "markers",
  cex.x = 1,
  cex.y = 1,
  pch.x = 21,
  pch.y = 23,
  col,
  mirrorX = FALSE,
  mirrorY = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{An \code{\linkS4class{MSnSet}} or a
\code{MSnSetList}. In the latter case, only the two first
elements of the list will be used for plotting and the others
will be silently ignored.}

\item{pcol}{If \code{object} is an \code{MSnSet}, a \code{factor}
or the name of a phenotype variable (\code{phenoData} slot)
defining how to split the single \code{MSnSet} into two or
more data sets.  Ignored if \code{object} is a
\code{\link{MSnSetList}}.}

\item{fcol}{Feature meta-data label (fData column name) defining
the groups to be differentiated using different
colours. Default is \code{markers}. Use \code{NULL} to
suppress any colouring.}

\item{cex.x}{Character expansion for the first data set. Default
is 1.}

\item{cex.y}{Character expansion for the second data set. Default
is 1.}

\item{pch.x}{Plotting character for the first data set. Default is
21.}

\item{pch.y}{Plotting character for the second data set. Default
is 23.}

\item{col}{A vector of colours to highlight the different classes
defined by \code{fcol}. If missing (default), default colours
are used (see \code{\link{getStockcol}}).}

\item{mirrorX}{A \code{logical} indicating whether the x axis
should be mirrored?}

\item{mirrorY}{A \code{logical} indicating whether the y axis
should be mirrored?}

\item{plot}{If \code{TRUE} (default), a plot is produced.}

\item{...}{Additinal parameters passed to \code{plot} and
\code{points}.}
}
\value{
Used for its side effects of producing a plot. Invisibly
    returns an object of class \code{plot2Ds}, which is a list
    with the PCA analyses results (see \code{\link{prcomp}}) of
    the first data set and the new coordinates of the second data
    sets, as used to produce the plot and the respective point
    colours. Each of these elements can be accessed with
    \code{data1}, \code{data2}, \code{col1} and \code{code2}
    respectively.
}
\description{
Takes 2 \code{linkS4class{MSnSet}} instances as input to plot the
two data sets on the same PCA plot. The second data points are
projected on the PC1 and PC2 dimensions calculated for the first
data set.
}
\examples{
library("pRolocdata")
data(tan2009r1)
data(tan2009r2)
msnl <- MSnSetList(list(tan2009r1, tan2009r2))
plot2Ds(msnl)
## tweaking the parameters
plot2Ds(list(tan2009r1, tan2009r2),
        fcol = NULL, cex.x = 1.5)
## input is 1 MSnSet containing 2 data sets
data(dunkley2006)
plot2Ds(dunkley2006, pcol = "replicate")
## no plot, just the data
res <- plot2Ds(dunkley2006, pcol = "replicate",
               plot = FALSE)
res
head(data1(res))
head(col1(res))
}
\seealso{
See \code{\link{plot2D}} to plot a single data set and
    \code{\link{move2Ds}} for a animation.
}
\author{
Laurent Gatto
}
