% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-knntl.R
\name{knntlClassification}
\alias{knntlClassification}
\title{knn transfer learning classification}
\usage{
knntlClassification(
  primary,
  auxiliary,
  fcol = "markers",
  bestTheta,
  k,
  scores = c("prediction", "all", "none"),
  seed
)
}
\arguments{
\item{primary}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{auxiliary}{An instance of class
\code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{bestTheta}{Best theta vector as output from
\code{knntlOptimisation}, see \code{knntlOptimisation} for
details}

\item{k}{Numeric vector of length 2, containing the best \code{k}
parameters to use for the primary and auxiliary datasets. If k
\code{k} is not specified it will be calculated internally.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{seed}{The optional random number generator seed.}
}
\value{
A character vector of the classifications for the unknowns
}
\description{
Classification using a variation of the KNN implementation
of Wu and Dietterich's transfer learning schema
}
\examples{
## Load example primary and auxiliary data from pRolocdata
library(pRolocdata)
data(andy2011)
data(andy2011goCC)

## reducing calculation time of k by pre-running knnOptimisation
x <- c(andy2011, andy2011goCC)
k <- lapply(x, function(z)
            knnOptimisation(z, times=5,
                            fcol = "markers.orig",
                            verbose = FALSE))
k <- sapply(k, function(z) getParams(z))

## Use by = 1 in optimisation i.e. give full weight to the 
## primary (indicated by 1) or full weight to auxiliary 
## (indicated by 0) reducing parameter search for example
## in this documentation only. See the transfer learning
## vignette for examples and details. 
opt <- knntlOptimisation(andy2011, andy2011goCC,
                         fcol = "markers.orig",
                         times = 2,
                         by = 1, 
                         k = k)
th <- getParams(opt)
plot(opt)

## Now perform classification after finding the best weights
res <- knntlClassification(andy2011, andy2011goCC,
                           fcol = "markers.orig", 
                           th, 
                           k)
}
\seealso{
\code{\link{knntlOptimisation}}
}
\author{
Lisa Breckels
}
