% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-knn.R
\name{knnClassification}
\alias{knnClassification}
\alias{knnPrediction}
\title{knn classification}
\usage{
knnClassification(
  object,
  assessRes,
  scores = c("prediction", "all", "none"),
  k,
  fcol = "markers",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{assessRes}{An instance of class
\code{"\linkS4class{GenRegRes}"}, as generated by
\code{\link{knnOptimisation}}.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{k}{If \code{assessRes} is missing, a \code{k} must be
provided.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{...}{Additional parameters passed to \code{\link{knn}} from
package \code{class}.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} with
    \code{knn} and \code{knn.scores} feature variables storing the
    classification results and scores respectively.
}
\description{
Classification using for the k-nearest neighbours algorithm.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- knnOptimisation(dunkley2006, k = c(3, 10), times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- knnClassification(dunkley2006, params)
getPredictions(res, fcol = "knn")
getPredictions(res, fcol = "knn", t = 0.75)
plot2D(res, fcol = "knn")
}
\author{
Laurent Gatto
}
