% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{setLisacol}
\alias{setLisacol}
\alias{getLisacol}
\alias{getOldcol}
\alias{setOldcol}
\alias{getStockcol}
\alias{setStockcol}
\alias{getStockpch}
\alias{setStockpch}
\alias{getUnknowncol}
\alias{setUnknowncol}
\alias{getUnknownpch}
\alias{setUnknownpch}
\alias{getStockbg}
\alias{setStockbg}
\alias{getUnknownbg}
\alias{setUnknownbg}
\title{Manage default colours and point characters}
\usage{
setLisacol()

getLisacol()

getOldcol()

setOldcol()

getStockcol()

setStockcol(cols)

getStockpch()

setStockpch(pchs)

getUnknowncol()

setUnknowncol(col)

getUnknownpch()

setUnknownpch(pch)

getStockbg()

setStockbg(bg)

getUnknownbg()

setUnknownbg(bg)
}
\arguments{
\item{cols}{A vector of colour \code{characters} or \code{NULL},
which sets the colours to the default values.}

\item{pchs}{A vector of \code{numeric} or \code{NULL},
which sets the point characters to the default values.}

\item{col}{A colour \code{character} or \code{NULL},
which sets the colour to \code{#E7E7E7} (\code{grey91}),
the default colour for unknown features.}

\item{pch}{A \code{numeric} vector of length 1 or \code{NULL},
which sets the point character to 21, the default.}

\item{bg}{A colour \code{character} or \code{NULL},
which sets the background (fill) colour for open plot symbols
given by pch = 21:25 to the default colour for unknown features.}
}
\value{
The \code{set} functions set (and invisibly returns)
colours. The \code{get} functions returns a \code{character}
vector of colours. For the \code{pch} functions, \code{numeric}s
rather than \code{character}s.
}
\description{
These functions allow to get/set the colours and point character
that are used when plotting organelle clusters and unknown
features. These values are parametrised at the session level. Two
palettes are available: the default palette (previously
\emph{Lisa's colours}) containing 30 colours and the old
(original) palette, containing 13 colours.
}
\examples{
## defaults for clusters
getStockcol()
getStockbg()
getStockpch()
## unknown features
getUnknowncol()
getUnknownbg()
getUnknownpch()
## an example
library(pRolocdata)
data(dunkley2006)
par(mfrow = c(2, 1))
plot2D(dunkley2006, fcol = "markers", main = 'Default colours')
setUnknowncol("black")
setUnknownbg("grey")
plot2D(dunkley2006, fcol = "markers", 
      main = 'setUnknowncol("black") and setUnknownbg("grey")')
getUnknowncol()
getUnknownbg()
setUnknowncol(NULL)
setUnknownbg(NULL)
getUnknowncol()
getStockcol()
getOldcol()
}
\author{
Laurent Gatto
}
