% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goannotations.R
\name{filterMinMarkers}
\alias{filterMinMarkers}
\title{Removes class/annotation information from a matrix of candidate
markers that appear in the \code{fData}.}
\usage{
filterMinMarkers(object, n = 10, p, fcol = "GOAnnotations", verbose = TRUE)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{n}{Minimum number of proteins allowed per column. Default is 10.}

\item{p}{Minimum percentage of proteins per column.}

\item{fcol}{The name of the matrix of marker information. Default is
\code{GOAnnotations}.}

\item{verbose}{Number of marker candidates retained after filtering.}
}
\value{
An updated \code{MSnSet}.
}
\description{
Removes annotation information that contain less that a
certain number/percentage of proteins
}
\examples{
library(pRolocdata)
data(dunkley2006)
xx <- dunkley2006
## create a matrix of markers
xx <- mrkVecToMat(xx, vfcol = "markers", mfcol = "Markers")
## Remove marker classes with less than 15 members, from matrix of markers
xx <- filterMinMarkers(xx, n = 15, fcol = "Markers")
## Remove marker classes with more than 50 members, from matrix of markers
xx <- filterMaxMarkers(xx, p = .2, fcol = "Markers")
}
\author{
Lisa M Breckels
}
