% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkFvarOverlap}
\alias{checkFvarOverlap}
\title{Compare a feature variable overlap}
\usage{
checkFvarOverlap(x, y, fcolx = "markers", fcoly, verbose = TRUE)
}
\arguments{
\item{x}{An \code{MSnSet} instance.}

\item{y}{An \code{MSnSet} instance.}

\item{fcolx}{The feature variable to separate unknown
(\code{fData(y)$coly == "unknown"}) from the marker features in
the \code{x} object.}

\item{fcoly}{As \code{fcolx}, for the \code{y} object. If missing,
the value of \code{fcolx} is used.}

\item{verbose}{If \code{TRUE} (default), the contingency table of
the the feature variables is printed out.}
}
\value{
Invisibly returns a named list with the values of the
diagonal, upper and lower triangles of the contingency table.
}
\description{
Extracts qualitative feature variables from two \code{MSnSet}
instances and compares with a contingency table.
}
\examples{
library("pRolocdata")
data(dunkley2006)
res <- checkFvarOverlap(dunkley2006, dunkley2006,
                        "markers", "markers.orig")
str(res)
}
\author{
Laurent Gatto
}
