% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{addMarkers}
\alias{addMarkers}
\title{Adds markers to the data}
\usage{
addMarkers(object, markers, mcol = "markers", fcol, verbose = TRUE)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{markers}{A \code{character} with the name the markers' csv
file or a named character of markers as provided by
\code{\link{pRolocmarkers}}.}

\item{mcol}{A \code{character} of length 1 defining the feature
variable label for the newly added markers. Default is
\code{"markers"}.}

\item{fcol}{An optional feature variable to be used to match
against the markers. If missing, the feature names are used.}

\item{verbose}{A \code{logical} indicating if number of markers
and marker table should be printed to the console.}
}
\value{
A new instance of class \code{MSnSet} with an additional
\code{markers} feature variable.
}
\description{
The function adds a 'markers' feature variable. These markers are
read from a comma separated values (csv) spreadsheet file. This
markers file is expected to have 2 columns (others are ignored)
where the first is the name of the marker features and the second
the group label. Alternatively, a markers named vector as provided
by the \code{\link{pRolocmarkers}} function can also be used.
}
\details{
It is essential to assure that \code{featureNames(object)} (or
\code{fcol}, see below) and marker names (first column) match,
i.e. the same feature identifiers and case fold are used.
}
\examples{
library("pRolocdata")
data(dunkley2006)
atha <- pRolocmarkers("atha")
try(addMarkers(dunkley2006, atha)) ## markers already exists
fData(dunkley2006)$markers.org <- fData(dunkley2006)$markers
fData(dunkley2006)$markers <- NULL
marked <- addMarkers(dunkley2006, atha)
fvarLabels(marked)
## if 'makers' already exists
marked <- addMarkers(marked, atha, mcol = "markers2")
fvarLabels(marked)
stopifnot(all.equal(fData(marked)$markers, fData(marked)$markers2))
plot2D(marked)
addLegend(marked, where = "topleft", cex = .7)
}
\seealso{
See \code{\link{pRolocmarkers}} for a list of spatial
markers and \code{\link{markers}} for details about markers
encoding.
}
\author{
Laurent Gatto
}
