% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_species.R
\name{format_species}
\alias{format_species}
\title{Format species names}
\usage{
format_species(
  species,
  remove_parentheses = TRUE,
  abbrev = FALSE,
  remove_subspecies = FALSE,
  remove_subspecies_exceptions = c("Canis lupus familiaris"),
  split_char = " ",
  collapse = " ",
  remove_chars = c(" ", ".", "(", ")", "[", "]"),
  replace_char = "",
  lowercase = FALSE,
  trim = "'",
  standardise_scientific = FALSE
)
}
\arguments{
\item{species}{Species query
(e.g. "human", "homo sapiens", "hsapiens", or 9606).
If given a list, will iterate queries for each item.
Set to \code{NULL} to return all species.}

\item{remove_parentheses}{Remove substring within parentheses: 
e.g. "Xenopus (Silurana) tropicalis" --> "Xenopus tropicalis"}

\item{abbrev}{Abbreviate all taxonomic levels except the last one:
e.g. "Canis lupus familiaris" ==> "C l familiaris"}

\item{remove_subspecies}{Only keep the first two taxonomic levels:
e.g. "Canis lupus familiaris" --> "Canis lupus"}

\item{remove_subspecies_exceptions}{Selected species to ignore when 
\code{remove_subspecies=TRUE}.
e.g. "Canis lupus familiaris" --> "Canis lupus familiaris"}

\item{split_char}{Character to split species names by.}

\item{collapse}{Character to re-collapse species names with after splitting
with \code{split_char}.}

\item{remove_chars}{Characters to remove.}

\item{replace_char}{Character to replace \code{remove_chars} with.}

\item{lowercase}{Make species names all lowercase.}

\item{trim}{Characters to trim from the beginning/end of each species name.}

\item{standardise_scientific}{Automatically sets multiple arguments at once
to create standardised scientific names for each species. Assumes that 
\code{species} is provided in some version of scientific species names:
e.g. "Xenopus (Silurana) tropicalis" --> "Xenopus tropicalis"}
}
\value{
A named vector where the values are the standardised species names
and the names are the original input species names.
}
\description{
Format scientific species names into a standardised manner.
}
\examples{
species <- c("Xenopus (Silurana) tropicalis","Canis lupus familiaris")
species2 <- format_species(species = species, abbrev=TRUE)
species3 <- format_species(species = species, 
                           standardise_scientific=TRUE,
                           remove_subspecies_exceptions=NULL)
}
