% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_genes_babelgene.R
\name{all_genes_babelgene}
\alias{all_genes_babelgene}
\title{Get all genes: babelgene}
\source{
\href{https://github.com/igordot/babelgene/issues/2}{
babelgene::orthologs_df version differences}
}
\usage{
all_genes_babelgene(
  species,
  run_map_species = TRUE,
  save_dir = tools::R_user_dir("orthogene", which = "cache"),
  use_old = FALSE,
  min_support = 1,
  verbose = TRUE
)
}
\arguments{
\item{species}{Species to get all genes for.
Will first be standardised with \code{map_species}.}

\item{run_map_species}{Standardise \code{species} names with 
\link[orthogene]{map_species} first (Default: \code{TRUE}).}

\item{save_dir}{Directory to save babelgene mapping files to.}

\item{use_old}{Use an old version of \code{babelgene::orthologs_df} 
(stored on GitHub Releases) for consistency.}

\item{verbose}{Print messages.}
}
\value{
All genes.
}
\description{
Get all genes for a given species using the method "babelgene".
}
\keyword{internal}
