% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimCovCellGeneral.R
\name{estimCovCellGeneral}
\alias{estimCovCellGeneral}
\title{estimCovCellGeneral}
\usage{
estimCovCellGeneral(cell, cytometry, labels, type = "standard", alpha = 0.85)
}
\arguments{
\item{cell}{Labell of the clsuter of interest.}

\item{cytometry}{Data of the partition, without labels.}

\item{labels}{Labels of the partition.}

\item{type}{How to estimate covariance matrices of a cluster. 'standard' is for using cov(), while 'robust' is for using robustbase::covMcd.}

\item{alpha}{Only when type = 'robust'. Indicates the value of alpha in robustbase::covMcd.}
}
\value{
A list containing:
\describe{
 \item{mean}{Mean of the cluster.}
 \item{cov}{Covariance of the cluster.}
 \item{weight}{Weight associated to the cluster.}
 \item{type}{Type of the cluster.}
}
}
\description{
Estimation of mean and covariance for a label in a partition.
}
\examples{
estimCovCellGeneral('Basophils', Cytometry1[,1:10], Cytometry1[,11])

}
