% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoPlotDatabase.R
\name{cytoPlotDatabase}
\alias{cytoPlotDatabase}
\title{cytoPlotDatabase}
\usage{
cytoPlotDatabase(
  database.cytometries.as.mixtures,
  dimensions = c(1, 2),
  xlim = c(0, 8000),
  ylim = c(0, 8000),
  xlab = "",
  ylab = "",
  colour = TRUE
)
}
\arguments{
\item{database.cytometries.as.mixtures}{A list where each component is a mixture distribution. That is, each component is a list, where each element contains the parameters of a component of the mixture as a list with entries: mean, cov, weight and type.}

\item{dimensions}{A vector containing the two variables on which to perform the projection.}

\item{xlim}{the x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a ‘reversed axis’. The default value, NULL, indicates that the range of the finite values to be plotted should be used.}

\item{ylim}{the y limits of the plot.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{colour}{If TRUE plots elements of a mixture distribution in different colours. If FALSE plots them in black.}
}
\value{
A two dimensional plot of ellipses containing the 95% of probability for the respectives components of the mixture distributions.
}
\description{
A plot wrapper for a database (list) of cytometries as a mixture of multivariate normals as used in optimalFlowTemplates.
}
\examples{
database <- buildDatabase(
  dataset_names = paste0('Cytometry', c(2:5, 7:9, 12:17, 19, 21)),
  population_ids = c('Monocytes', 'CD4+CD8-', 'Mature SIg Kappa', 'TCRgd-'))
templates.optimalFlow <-
  optimalFlowTemplates(
    database = database, templates.number = 5, cl.paral = 1
  )
cytoPlotDatabase(templates.optimalFlow$database.elliptical[which(templates.optimalFlow$clustering == 3)], dimensions = c(4,3), xlim = c(0, 8000), ylim = c(0, 8000), xlab = "", ylab = "")

}
