% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_greedy.R
\name{optimize.primer.cvg}
\alias{optimize.primer.cvg}
\title{Greedy Optimization}
\usage{
optimize.primer.cvg(
  primers,
  template.df,
  mode.directionality,
  cur.opti.constraints,
  target.temp,
  allowed.mismatches,
  opti.limits,
  primer_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  updateProgress = NULL
)
}
\arguments{
\item{primers}{Primer data frame to be optimized.}

\item{template.df}{Template data frame.}

\item{mode.directionality}{Primer direction.}

\item{cur.opti.constraints}{List with optimization constraint settings.}

\item{target.temp}{Target annealing temperature of the optimized primer set in Celsius.}

\item{allowed.mismatches}{The number of mismatches primers are allowed to have with the templates.}

\item{opti.limits}{List with optimization limits.}

\item{primer_conc}{Primer concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris ion concentration.}

\item{updateProgress}{Shiny progress callback function.}

\item{template_conc}{Template concentration.}
}
\value{
List with optimization data.
}
\description{
Greedy approach for solving the primer set coverage problem.
}
\keyword{internal}
