% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_ILP.R
\name{optimize.ILP}
\alias{optimize.ILP}
\title{Solver for ILP Set Cover}
\usage{
optimize.ILP(
  primer.df,
  template.df,
  settings,
  primer_conc,
  template_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  allowed.mismatches,
  allowed.other.binding.ratio,
  allowed.stop.codons,
  allowed.region.definition,
  disallowed.mismatch.pos,
  target.temps,
  required.cvg,
  fw.primers = NULL,
  diagnostic.location = NULL,
  timeout = Inf,
  updateProgress = NULL
)
}
\arguments{
\item{primer.df}{Primer data frame to be optimized.}

\item{template.df}{Template data frame with sequences.}

\item{settings}{A \code{DesignSettings} object.}

\item{primer_conc}{Primer concentration.}

\item{template_conc}{Template concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris ion concentration.}

\item{allowed.mismatches}{The number of mismatches primers are allowed to have with the templates.}

\item{allowed.other.binding.ratio}{Ratio of primers allowed to bind to non-target regions.}

\item{allowed.stop.codons}{Consider mismatch binding events that induce stop codons.}

\item{allowed.region.definition}{Definition of the target binding sites used for evaluating the coverage.
If \code{allowed.region.definition} is \code{within}, primers have to lie within the allowed binding region.
If \code{allowed.region.definition} is \code{any}, primers have to overlap with the allowed binding region.
The default is that primers have to bind within the target binding region.}

\item{disallowed.mismatch.pos}{The number of positions from the primer 3' end where mismatches should not be allowed.
All primers binding templates with mismatches within \code{disallowed.mismatch.pos} from the 3' end are disregarded.}

\item{target.temps}{Target melting temperatures for primer sets in Celsius.}

\item{required.cvg}{Target coverage ratio of the templates by the primers.}

\item{fw.primers}{List with optimized primer data frames corresponding to \code{target.temps}. 
Only required for optimizing both strand directions and only 
in the second optimization run in order to check for cross dimerization.}

\item{diagnostic.location}{Directory for storing results.}

\item{timeout}{Timeout in seconds for the optimization with ILPs.}

\item{updateProgress}{Shiny progress callback function.}
}
\value{
List with optimization results.
}
\description{
Solves the primer set cover problem using an ILP formulation.
}
\keyword{internal}
