% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primers.R
\name{get_covered.vanilla}
\alias{get_covered.vanilla}
\title{Determination of the Covered Sequences.}
\usage{
get_covered.vanilla(primers, template.df, mode.directionality = NULL)
}
\arguments{
\item{primers}{A \code{Primers} object containing the primers
for which the coverage should be evaluated.}

\item{template.df}{A \code{Templates} object containing
the template sequences corresponding to \code{primers}.}

\item{mode.directionality}{If \code{mode.directionality} is provided,
the coverage of templates is computed for a specific direction of primers.
Either "fw" (forward coverage only), "rev" (reverse coverage only), or "both" for both directions. If \code{mode.directionality} is not provided
the direction is determined by the input primers.}
}
\value{
The IDs of all covered templates.
}
\description{
Determines the covered template sequences given by \code{template.df} 
that are covered by the primers given by \code{primers}.
}
\details{
The manner in which the coverage ratio is evaluated depends on 
the directionality of the input primers.
If either only forward or reverse primers are inputted, the individual
coverage of each primer is used to determine the overall coverage. If, however,
forward and reverse primers are inputted at the same time, 
the coverage is defined by the intersection of binding events from both,
forward and reverse primers.
}
\keyword{internal}
