% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{get.cvg.gain}
\alias{get.cvg.gain}
\title{Computation of Coverage Gain.}
\usage{
get.cvg.gain(
  covered.seqs,
  template.df,
  missing.df,
  candidate.df,
  con.names,
  constraint.limits,
  feasible.only = FALSE
)
}
\arguments{
\item{covered.seqs}{List with covered sequences.}

\item{template.df}{A \code{Templates} data frame.}

\item{missing.df}{A \code{Templates} data frame 
containing only the templates that still need to be covered.}

\item{candidate.df}{A \code{Primers} data frame containing
candidate primers.}

\item{con.names}{The constraint to evaluate the coverage gain for
upon being relaxed.}

\item{constraint.limits}{A list with constraint limits.}

\item{feasible.only}{Whether only feasible coverage gains 
are to be outtputed. Here, \emph{feasible} relates to 
coverage gains that can be obtained directly with the next relaxation.}
}
\value{
The number of covered sequences to be gained.
}
\description{
Computes the coverage gain from \code{covered.seqs}.
}
\keyword{internal}
