% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints_eval.R
\name{eval.constraints}
\alias{eval.constraints}
\title{Evaluation of Constraints'}
\usage{
eval.constraints(
  constraint.df,
  constraint.settings,
  active.constraints,
  mode.directionality = c("fw", "rev", "both"),
  primer.df
)
}
\arguments{
\item{constraint.df}{Primer data frame with computed constraints.}

\item{constraint.settings}{List with allowed values pers constraint.}

\item{active.constraints}{Names of constraints to be evaluated.}

\item{mode.directionality}{Directionality of primers}

\item{primer.df}{Primer data frame corresponding to \code{constraint.df}.}
}
\value{
Augments the \code{constraint.df} data frame with evaluation columns.
}
\description{
Evaluates whether the given primer data frame fulfills the required conditions.
}
\details{
Constraint values should be contained in \code{constraint.df}. 
For each constraint in \code{active.constraints}, a boolean column with the name
\code{EVAL_<constraint_name>} is generated, which indicates whether 
a primer in a given rows fulfills a constraint or not.
}
\keyword{internal}
