% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_primers.R
\name{create.initial.primer.set}
\alias{create.initial.primer.set}
\title{Creation of an Initial Primer Set.}
\usage{
create.initial.primer.set(
  template.df,
  primer.lengths,
  mode.directionality = c("fw", "rev"),
  sample,
  allowed.region.definition = c("within", "any"),
  init.algo = c("naive", "tree"),
  max.degen,
  conservation,
  updateProgress = NULL
)
}
\arguments{
\item{template.df}{Template data frame.}

\item{primer.lengths}{Vector containing the permissible primer lengths.}

\item{mode.directionality}{Direction of primers to be created.}

\item{sample}{Name of the template sample.}

\item{allowed.region.definition}{Definition of the allowed binding region.}

\item{init.algo}{Algorithm for initializing primers.}

\item{max.degen}{Maximal allowed degeneration of created primers.}

\item{conservation}{Required conservation of primers.
The value of \code{conservation} should be in the range[0,1].}

\item{updateProgress}{Shiny progress object.}
}
\value{
An initialized data frame of candidate primers.
}
\description{
Creates an initial set of candidate primers for primer design.
}
\keyword{internal}
