% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints_eval.R
\name{compute.constraints}
\alias{compute.constraints}
\title{Computation of Constraints.}
\usage{
compute.constraints(
  primer.df,
  mode.directionality = c("fw", "rev", "both"),
  template.df,
  settings,
  active.constraints = c("primer_coverage", "primer_length", "primer_specificity",
    "gc_clamp", "gc_ratio", "no_runs", "no_repeats", "self_dimerization",
    "cross_dimerization", "melting_temp_range", "melting_temp_diff",
    "secondary_structure", "primer_efficiency", "annealing_DeltaG", "stop_codon",
    "terminal_mismatch_pos", "substitution", "hexamer_coverage", "coverage_model",
    "off_primer_efficiency", "off_annealing_DeltaG", "off_coverage_model"),
  no.structures = FALSE,
  for.shiny = FALSE,
  updateProgress = NULL
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{mode.directionality}{Primer directionality.}

\item{template.df}{Template data frame.}

\item{settings}{A \code{DesignSettings} object.}

\item{active.constraints}{Strings giving the constraints that are to be computed.}

\item{no.structures}{Whether dimer structures shall be computed.}

\item{for.shiny}{Whether to format output for HTML.}

\item{updateProgress}{Progress callback function for shiny.}
}
\value{
A data frame with columns for each constraint in \code{active.constraints}.
}
\description{
Computes the specified constraints for the input primers.
}
\keyword{internal}
