% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primers.R
\name{check_restriction_sites_single}
\alias{check_restriction_sites_single}
\title{Identification of Sequence Restriction Sites.}
\usage{
check_restriction_sites_single(
  primer.seqs,
  template.seqs,
  adapter.action,
  direction = c("fw", "rev"),
  selected = NULL,
  only.confident.calls = TRUE,
  updateProgress = NULL
)
}
\arguments{
\item{primer.seqs}{Nucleotide sequences of primers to be checked for restriction sites in terms of a \code{DNAStringSet} object.}

\item{template.seqs}{A \code{DNAStringSet} object with nucleotide sequences 
containing the templates corresponding to \code{seqs}.}

\item{adapter.action}{The action to be performed when adapter sequences
are found. Either "warn" to issue warning about adapter sequences or
"rm" to remove identified adapter sequences.}

\item{selected}{Names of restriction sites that are to be checked.
By default \code{selected} is \code{NULL} in which case all REBASE 
restriction sites are checked.}

\item{only.confident.calls}{Only output confident calls of restriction sites.}

\item{updateProgress}{A Shiny progress callback function.}

\item{The}{primer direction that is checked.}
}
\value{
A data frame with restriction sites, if any could be found.
}
\description{
Checks the input sequences \code{seqs} for the presence of
restriction sites. By removing the restriction sites from a primer set, 
it is possible to identify the coverage of the primers
(e.g. using \code{\link{check_constraints}}) discounting for 
the impact of the mismatching bases caused by the insert.
}
\references{
Roberts, R.J., Vincze, T., Posfai, J., Macelis, D. (2010) REBASE–a database for DNA restriction
and modification: enzymes, genes and genomes. Nucl. Acids Res. 38: D234-D236. http://rebase.neb.com
}
\keyword{internal}
