% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_primer_coverage.R
\name{check.mutations}
\alias{check.mutations}
\title{Identification of Mismatch Mutations.}
\usage{
check.mutations(
  primer.seq,
  pos.start,
  pos.end,
  template.df,
  covered.seqs,
  ORF.data,
  mode.directionality = c("fw", "rev"),
  mutation.types = c("stop_codon", "substitution")
)
}
\arguments{
\item{primer.seq}{Primer sequence string.}

\item{pos.start}{Binding position of primer (start).}

\item{pos.end}{Binding position of primer (end).}

\item{template.df}{Template data frame.}

\item{covered.seqs}{Identifiers of covered templates.}

\item{ORF.data}{Reading frame information of templates.}

\item{mode.directionality}{Directionality of primers.}

\item{mutation.types}{Character vector of the mutation types to be checked for.}
}
\value{
TRUE if the \code{primer.seq} induces a mutation that is
forbidden according to the provided \code{mutation.types}.
}
\description{
Identifies primers that induce mutations due to mismatch binding.
}
\details{
Checks for one primer and all covered templates whether any templates are bound
with mismatches such that a forbidden mutation is induced. A boolean vector indicating 
which binding events induce a forbidden mutation is returned.
}
\keyword{internal}
