% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{cascaded.filter.quick}
\alias{cascaded.filter.quick}
\title{Cascaded Filter}
\usage{
cascaded.filter.quick(
  primer.df,
  template.df,
  settings,
  to.compute.constraints,
  mode.directionality = c("fw", "rev", "both"),
  active.constraints = NULL,
  no.structures = FALSE,
  updateProgress = NULL
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{template.df}{Template data frame.}

\item{settings}{Settings object.}

\item{to.compute.constraints}{Names of constraints that still have to be computed.}

\item{mode.directionality}{Primer direction.}

\item{active.constraints}{The constraints that are to be used for filtering.
If \code{active.constraints} is \code{NULL}, all filtering constraints are used.}

\item{no.structures}{Whether dimerization structures shall be computed.}

\item{updateProgress}{Progress callback function for shiny.}
}
\value{
The filtered primer data frame.
}
\description{
Filter primers in a cascaded fashion.
}
\details{
At each constraint evaluation all primers that do not fulfill the current constraint are removed.

Constraints that are specified in \code{to.compute.constraints} are computed on the fly.
}
\keyword{internal}
