context("gating method that takes no dimensions")

test_that(" gating method that simply return Logical vector", {
  gs <- GatingSet(GvHD[1])
  # Add a gate
  gs_pop_add(
      gs,
        parent = "root",
        gate = rectangleGate(
              "FSC-H"=c(225,500), 
                  "SSC-H"=c(15, 150),
                  filterId="test"
        )
  )
        
  #create a dummy gating function that mimic sampling method
  dummy_func <- function(fr, pp_res, channels, ...)
  {
    n = nrow(fr)
    res = rep(TRUE,n)
    return (res)
  }
  #register it as the plugin gating method
  register_plugins(dummy_func, "sample_method")
  #apply it to the gs
  gs_add_gating_method(gs, alias = "A", parent = "root", pop = "*", dims = "", gating_method = "sample_method")
  
  expect_equal(gs_get_pop_paths(gs),c("root","/test","/A"))
  expect_is(gh_pop_get_gate(gs[[1]], "A"), "booleanFilter")
})
  
test_that("clustering gating method that returns factor representing multiple clusters generated by the clustering", {
    gs <- GatingSet(GvHD[1])
  
      #create a dummy gating function that mimic clustering method
  dummy_func <- function(fr, pp_res, channels, ...)
  {
    n = nrow(fr)
    res = rep(1,n)
    res[1:10] = 2
    res = factor(res)
    return (res)
  }
  #register it as the plugin gating method
  register_plugins(dummy_func, "clustering_B")
  # Note that alias must be *, the generated clustering populations are named after gating method and factor level
  gs_add_gating_method(gs, alias = "*", parent = "root", pop = "*", dims = "", gating_method = "clustering_B")
  
  expect_equal(gs_get_pop_paths(gs),c("root","/clustering_B_1","/clustering_B_2"))
  expect_is(gh_pop_get_gate(gs[[1]], "clustering_B_1"), "booleanFilter")  
})


test_that("clustering gating method that returns multipleFilterResult", {
  gs <- GatingSet(GvHD[1])
  
  #create a dummy gating function that mimic clustering method
  dummy_func <- function(fr, pp_res, channels, ...)
  {
    n = nrow(fr)
    res = rep(1,n)
    res[1:10] = 2
    res = factor(res)
    # Now we  explicitly name these populations
    levels(res) = c("cluster_A", "cluster_B")
    res = as(res, "filterResult")
    
    return (res)
  }
  #register it as the plugin gating method
  register_plugins(dummy_func, "clustering_method1")
  gs_add_gating_method(gs, alias = "*", parent = "root", pop = "*", dims = "", gating_method = "clustering_method1")
  
  expect_equal(gs_get_pop_paths(gs),c("root","/cluster_A","/cluster_B"))
  expect_is(gh_pop_get_gate(gs[[1]], "cluster_B"), "booleanFilter")  
})

